/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PROD_TBL_FIDEL_PONTUACAO]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_TBL_FIDEL_PONTUACAO]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PROD_TBL_FIDEL_PONTUACAO]
GO 
GO
GO
--SELECT * FROM UFD_EST_PROD_TBL_FIDEL_PONTUACAO (1,1,142725)
CREATE FUNCTION UFD_EST_PROD_TBL_FIDEL_PONTUACAO (@CD_EMP INT, @CD_FILIAL INT, @CD_PROD INT)
RETURNS @RS_RETURN TABLE(CD_EMP INT, 
					     CD_FILIAL INT,
                         CD_PROD INT,    
                         CD_TBL_FIDEL INT,    
                         CD_INTEGRADORA INT,
						 DT_INI DATETIME,
						 DT_FIM DATETIME,
                         QTDE_PONTO MONEY)
AS
begin

DECLARE @CD_ARV_MERC_LINHA INT
DECLARE @CD_ARV_MERC_CATEG INT
DECLARE @CD_FABRIC INT
DECLARE @CD_MC INT
DECLARE @CD_ARV_MERC_FAMILIA INT

DECLARE @DT_ATUAL DATETIME

SET @DT_ATUAL= CONVERT(CHAR(10),GETDATE(),112)

--Buscando dados do produto
SELECT
	@CD_ARV_MERC_LINHA=a.CD_ARV_MERC_LINHA,
	@CD_ARV_MERC_CATEG=a.CD_ARV_MERC_CATEG,
	@CD_FABRIC=p.CD_FABRIC,
	@CD_MC=p.CD_MC,
	@CD_ARV_MERC_FAMILIA=a.CD_ARV_MERC_FAMILIA
FROM
	EST_PROD p INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA a ON
	p.CD_EMP = a.CD_EMP AND
	p.CD_PROD = a.CD_PROD 
WHERE
	p.CD_EMP =@CD_EMP
	AND p.CD_PROD = @CD_PROD

--Retornando dados 
INSERT INTO @RS_RETURN
SELECT
	rs.CD_EMP,
	EST_PROD_TBL_FIDEL_PRC_FILIAL.CD_FILIAL,
	@CD_PROD AS CD_PROD,
	rs.CD_TBL_FIDEL, 
	EST_PROD_TBL_FIDEL.CD_INTEGRADORA, 
	EST_PROD_TBL_FIDEL.DT_INI, 
	EST_PROD_TBL_FIDEL.DT_FIM, 
	CASE WHEN SUM(QTDE_PONTO_PRODUTO)> 0 THEN
		SUM(QTDE_PONTO_PRODUTO)
	WHEN SUM(QTDE_PONTO_FAMILIA)> 0 THEN
		SUM(QTDE_PONTO_FAMILIA)
	WHEN SUM(QTDE_PONTO_MC)> 0 THEN
		SUM(QTDE_PONTO_MC)
	WHEN SUM(QTDE_PONTO_FABRIC)> 0 THEN
		SUM(QTDE_PONTO_FABRIC)
	WHEN SUM(QTDE_PONTO_CATEGORIA)> 0 THEN
		SUM(QTDE_PONTO_CATEGORIA)
	WHEN SUM(QTDE_PONTO_LINHA)> 0 THEN
		SUM(QTDE_PONTO_LINHA)
	WHEN EST_PROD_TBL_FIDEL_PRC_FILIAL.QTDE_PONTO > 0 THEN
		EST_PROD_TBL_FIDEL_PRC_FILIAL.QTDE_PONTO
	ELSE
		0
	END AS QTDE_PONTO
FROM
(SELECT   
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_LINHA.CD_EMP,
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_LINHA.CD_TBL_FIDEL, 
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA,
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_LINHA.QTDE_PONTO AS QTDE_PONTO_LINHA,
	0 AS CD_ARV_MERC_CATEG,
    0 AS QTDE_PONTO_CATEGORIA, 
	0 AS CD_FABRIC,
	0 AS QTDE_PONTO_FABRIC, 
	0 AS CD_MC,
	0 AS QTDE_PONTO_MC, 
	0 AS CD_ARV_MERC_FAMILIA,
    0 AS QTDE_PONTO_FAMILIA, 
	0 AS CD_PROD,
	0 AS QTDE_PONTO_PRODUTO
FROM            
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_LINHA 
WHERE
	CD_EMP =@CD_EMP
	AND CD_ARV_MERC_LINHA=@CD_ARV_MERC_LINHA
UNION ALL
SELECT        
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_CATEGORIA.CD_EMP,
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_CATEGORIA.CD_TBL_FIDEL, 
	0 AS CD_ARV_MERC_LINHA,
	0 AS QTDE_PONTO_LINHA,
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_CATEG,
    EST_PROD_TBL_FIDEL_EST_ARV_MERC_CATEGORIA.QTDE_PONTO AS QTDE_PONTO_CATEGORIA,
	0 AS CD_FABRIC,
	0 AS QTDE_PONTO_FABRIC, 
	0 AS CD_MC,
	0 AS QTDE_PONTO_MC, 
	0 AS CD_ARV_MERC_FAMILIA,
    0 AS QTDE_PONTO_FAMILIA, 
	0 AS CD_PROD,
	0 AS QTDE_PONTO_PRODUTO
FROM            
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_CATEGORIA  
WHERE
	CD_EMP =@CD_EMP
	AND CD_ARV_MERC_CATEG=@CD_ARV_MERC_CATEG
UNION ALL
SELECT        
	EST_PROD_TBL_FIDEL_EST_PROD_FABRIC.CD_EMP,
	EST_PROD_TBL_FIDEL_EST_PROD_FABRIC.CD_TBL_FIDEL, 
	0 AS CD_ARV_MERC_LINHA,
	0 AS QTDE_PONTO_LINHA,
	0 AS CD_ARV_MERC_CATEG,
    0  AS QTDE_PONTO_CATEGORIA,
	EST_PROD_TBL_FIDEL_EST_PROD_FABRIC.CD_FABRIC,
	EST_PROD_TBL_FIDEL_EST_PROD_FABRIC.QTDE_PONTO AS QTDE_PONTO_FABRIC,
	0 AS CD_MC,
	0 AS QTDE_PONTO_MC, 
	0 AS CD_ARV_MERC_FAMILIA,
    0 AS QTDE_PONTO_FAMILIA, 
	0 AS CD_PROD,
	0 AS QTDE_PONTO_PRODUTO
FROM            
	EST_PROD_TBL_FIDEL_EST_PROD_FABRIC 
WHERE
	CD_EMP =@CD_EMP
	AND CD_FABRIC=@CD_FABRIC
UNION ALL
SELECT        
	EST_PROD_TBL_FIDEL_EST_MC.CD_EMP,
	EST_PROD_TBL_FIDEL_EST_MC.CD_TBL_FIDEL, 
	0 AS CD_ARV_MERC_LINHA,
	0 AS QTDE_PONTO_LINHA,
	0 AS CD_ARV_MERC_CATEG,
    0  AS QTDE_PONTO_CATEGORIA,
	0 AS CD_FABRIC,
	0 AS QTDE_PONTO_FABRIC,
	EST_PROD_TBL_FIDEL_EST_MC.CD_MC,
	EST_PROD_TBL_FIDEL_EST_MC.QTDE_PONTO AS QTDE_PONTO_MC, 
	0 AS CD_ARV_MERC_FAMILIA,
    0 AS QTDE_PONTO_FAMILIA, 
	0 AS CD_PROD,
	0 AS QTDE_PONTO_PRODUTO
FROM            
	EST_PROD_TBL_FIDEL_EST_MC 
WHERE
	CD_EMP =@CD_EMP
	AND CD_MC=@CD_MC
UNION ALL
SELECT        
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA.CD_EMP,
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA.CD_TBL_FIDEL, 
	0 AS CD_ARV_MERC_LINHA,
	0 AS QTDE_PONTO_LINHA,
	0 AS CD_ARV_MERC_CATEG,
    0  AS QTDE_PONTO_CATEGORIA,
	0 AS CD_FABRIC,
	0 AS QTDE_PONTO_FABRIC,
	0 AS CD_MC,
	0 AS QTDE_PONTO_MC, 
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA,
    EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA.QTDE_PONTO AS QTDE_PONTO_FAMILIA,  
	0 AS CD_PROD,
	0 AS QTDE_PONTO_PRODUTO
FROM            
	EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA 
WHERE
	CD_EMP =@CD_EMP
	AND CD_ARV_MERC_FAMILIA=@CD_ARV_MERC_FAMILIA
UNION ALL
SELECT        
	EST_PROD_TBL_FIDEL_EST_PROD.CD_EMP,
	EST_PROD_TBL_FIDEL_EST_PROD.CD_TBL_FIDEL, 
	0 AS CD_ARV_MERC_LINHA,
	0 AS QTDE_PONTO_LINHA,
	0 AS CD_ARV_MERC_CATEG,
    0  AS QTDE_PONTO_CATEGORIA,
	0 AS CD_FABRIC,
	0 AS QTDE_PONTO_FABRIC,
	0 AS CD_MC,
	0 AS QTDE_PONTO_MC, 
	0 AS CD_ARV_MERC_FAMILIA,
    0 AS QTDE_PONTO_FAMILIA,  
	EST_PROD_TBL_FIDEL_EST_PROD.CD_PROD,
	EST_PROD_TBL_FIDEL_EST_PROD.QTDE_PONTO AS QTDE_PONTO_PRODUTO
FROM            
	EST_PROD_TBL_FIDEL_EST_PROD
WHERE
	CD_EMP =@CD_EMP
	AND CD_PROD=@CD_PROD) rs INNER JOIN EST_PROD_TBL_FIDEL_PRC_FILIAL ON 
	rs.CD_EMP = EST_PROD_TBL_FIDEL_PRC_FILIAL.CD_EMP AND 
    rs.CD_TBL_FIDEL = EST_PROD_TBL_FIDEL_PRC_FILIAL.CD_TBL_FIDEL 
	INNER JOIN EST_PROD_TBL_FIDEL ON
	rs.CD_EMP = EST_PROD_TBL_FIDEL.CD_EMP AND 
    rs.CD_TBL_FIDEL = EST_PROD_TBL_FIDEL.CD_TBL_FIDEL 
WHERE
	EST_PROD_TBL_FIDEL_PRC_FILIAL.CD_EMP =@CD_EMP
	AND EST_PROD_TBL_FIDEL_PRC_FILIAL.CD_FILIAL=@CD_FILIAL
	AND @DT_ATUAL BETWEEN DT_INI AND DT_FIM
GROUP BY	
	rs.CD_EMP,
	rs.CD_TBL_FIDEL,
	EST_PROD_TBL_FIDEL_PRC_FILIAL.CD_FILIAL,
	EST_PROD_TBL_FIDEL_PRC_FILIAL.QTDE_PONTO,
	EST_PROD_TBL_FIDEL.CD_INTEGRADORA, 
	EST_PROD_TBL_FIDEL.DT_INI, 
	EST_PROD_TBL_FIDEL.DT_FIM
    RETURN 
end